﻿using UnityEngine;
using UnityEngine.SceneManagement;
using UnityStandardAssets.Characters.FirstPerson;

public class GameManager : MonoBehaviour
{
    public GoalScript blue, green, red, orange;
    public ChaosScript chaos;
    private bool isGameOver = false;
    private float elapsedTime = 0;

    void Update()
    {
        // Update is called once per frame

        // Add time to the clock if the game is running
        if (!isGameOver)
        {
            elapsedTime = elapsedTime + Time.deltaTime;
        }

        // If all four goals are solved then the game is over
        isGameOver = chaos.isSolved;
    }
    void reloadGame()
    {
        SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex);
    }

    void OnGUI()
    {
        if (isGameOver)
        {
            string message = "";

            if (isGameOver)
            {
                message = "Click or Press Enter to Play Again";
                //fpsController = fpsController.GetComponent<FirstPersonCharacter>();

                // Disables controls at the start.
                //fpsController.enabled = false;
            }


            //Define a new rectangle for the UI on the screen
            Rect startButton = new Rect(Screen.width / 2 - 120, Screen.height / 2, 240, 30);

            if (GUI.Button(startButton, message) || Input.GetKeyDown(KeyCode.Return))
            {
                //start the game if the user clicks to play
                reloadGame();
            }
        }
        if (isGameOver)
        {

            GUI.Box(new Rect(Screen.width / 2 - 85, 185, 180, 40), "Good Job. Your Time Was");
            GUI.Label(new Rect(Screen.width / 2 - 10, 200, 20, 30), ((int)elapsedTime).ToString());
        }
        if (!isGameOver)
        {
            // If the game is running, show the current time
            GUI.Box(new Rect(Screen.width / 2 - 65, Screen.height - 115, 130, 40), "Your Time Is");
            GUI.Label(new Rect(Screen.width / 2 - 10, Screen.height - 100, 20, 30), ((int)elapsedTime).ToString());
        }
    }
}